-- MAXScript File
-- Created:  May 04, 2011
-- Author:   David Cunningham
-- Support scripts for Ribbon
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

struct Main_Ribbon
(
	
fn AllAreEditPatch =
(
	local isPatch = true
	if (classof $ != ObjectSet) then
	(
		isPatch = classof $ == Editable_Patch
	)
	else 
	(
		for i = 1 to $.count while isPatch do
		(
			isPatch = classof $[i] == Editable_Patch
		)
	)
	isPatch
),

fn AllAreClass classToCheck=
(
	local isClass = true
	if (classof $ != ObjectSet) then
	(
		isClass = classof $ == classToCheck
	)
	else 
	(
		for i = 1 to $.count while isClass do
		(
			isClass = classof $[i] == classToCheck
		)
	)
	isClass
),

fn AllAreSuperclass superclassToCheck=
(
	local isClass = true
	if (classof $ != ObjectSet) then
	(
		isClass = superclassof $ == superclassToCheck
	)
	else 
	(
		for i = 1 to $.count while isClass do
		(
			isClass = superclassof $[i] == superclassToCheck
		)
	)
	isClass
),

fn IsPrimitive objToCheck=
(
	if(objToCheck != undefined) then objToCheck.category == #Standard_Primitives or objToCheck.category == #Extended_Primitives 
	else
		false
),

fn AllArePrimitives =
(
	local isPrim = true
	if (classof $ != ObjectSet) then
	(
		isPrim = IsPrimitive $
	)
	else 
	(
		for i = 1 to $.count while isPrim do
		(
			isPrim = Main_Ribbon.IsPrimitive $[i]
		)
	)
	isPrim
),

fn FlipAllLights =
(
	for x in $selection where ((superclassof x.baseobject)==Light) do (try ( x.on = (not x.on)); catch())
),


fn EscapeSOMode =
(
	subobjectlevel=0
	clearselection()
),


fn AllChildrenSelectedRecursive theNode =
(
	local res = true
	for child in theNode.children while res do
	(
		if  not child.isSelected then 
			res = false
		else
			res = Main_Ribbon.AllChildrenSelectedRecursive child
	)
	res
),

fn IsValidGroupSelection =
(
	local selCount = selection.count
	local onlyWholeGroupSelected = selCount != 0
	-- check for the edge case of a single open group head selected
	if(selcount == 1 and (isOpenGroupHead $ or isGroupMember $)) then
	(
    	onlyWholeGroupSelected = true
	)
	else 
	(
		for obj in selection while (onlyWholeGroupSelected) do
		(
			onlyWholeGroupSelected = ((isGroupMember obj) and obj.parent.isSelected) or (isGroupHead obj)
			if (onlyWholeGroupSelected and (isGroupHead obj)) do
			(
				onlyWholeGroupSelected = Main_Ribbon.AllChildrenSelectedRecursive obj
			)
		)
	)
	onlyWholeGroupSelected
)

)